/* 
   This file is part of Practical Distributed Processing
   Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige
*/

#ifndef _MISC_HDR
#define _MISC_HDR

#include <sys/socket.h>

/* Loop, reading from user and sending on s (STREAM socket). */
void readloop (int s);

/* Loop, reading from user and sending on s (unconnected
   DGRAM socket). */
void readloop2 (int                    s,
		const struct sockaddr *a, 
		socklen_t              alen);

/* Loop, reading from user and sending on s (STREAM socket), like
   readloop.  Then receive a single string on s. */
void readloop3 (int s);

/* Loop, reading from user and sending on s (STREAM socket), like
   readloop.  This uses select() to avoid strict turns. */
void readloop4 (int s);


#endif
